<?php $__env->startSection('tab-title'); ?>
    <?php echo e(trans_choice('accounting::general.account_subtype', 2), false); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('tab-content'); ?>
    <!-- Main content -->
    <section class="content no-print">
        <div class="row">

            <h3 style="padding: 0px 24px;"><?php echo e(trans_choice('accounting::general.account_subtype', 2), false); ?></h3>

            <!-- Main content -->
            <section class="content">

                <?php $__currentLoopData = $account_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $__env->startComponent('accounting::components.box'); ?>
                        <?php $__env->slot('title'); ?>
                            <?php echo e(ucfirst($account_type->plural_name), false); ?>

                        <?php $__env->endSlot(); ?>

                        <?php $__env->slot('header'); ?>
                            <div class="box-tools">
                                <a href="#" class="btn btn-primary" data-toggle="modal" data-target="#createAccountSubtypeModal"
                                    @click="setAccountType('<?php echo e($account_type->id, false); ?>')">
                                    <i class="fas fa-plus"></i> <?php echo e(trans_choice('accounting::lang.add', 1), false); ?>

                                </a>
                            </div>
                        <?php $__env->endSlot(); ?>

                        <?php $__env->slot('body'); ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-condensed table-hover datatable">
                                    <thead>
                                        <tr>
                                            <th>
                                                <?php echo e(trans_choice('accounting::lang.name', 1), false); ?>

                                            </th>
                                            <th>
                                                <?php echo e(trans_choice('accounting::lang.active', 1), false); ?>

                                            </th>
                                            <th>
                                                <?php echo e(trans_choice('accounting::lang.action', 1), false); ?>

                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                            $filtered_account_subtypes = $account_subtypes->where('account_type', $account_type->id);
                                        ?>
                                        <?php if(!empty($filtered_account_subtypes)): ?>
                                            <?php $__currentLoopData = $filtered_account_subtypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <span><?php echo e($key->name, false); ?></span>
                                                    </td>
                                                    <td>
                                                        <?php if($key->active): ?>
                                                            <span class="label label-success">
                                                                <?php echo e(trans('accounting::lang.yes'), false); ?>

                                                            </span>
                                                        <?php else: ?>
                                                            <span class="label label-danger">
                                                                <?php echo e(trans('accounting::lang.no'), false); ?>

                                                            </span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php if(!$key->is_default_type): ?>
                                                            <div class="btn-group">
                                                                <button href="#" class="btn btn-info dropdown-toggle btn-xs"
                                                                    data-toggle="dropdown"
                                                                    aria-expanded="false"><?php echo e(trans_choice('accounting::lang.action', 1), false); ?>

                                                                    <span class="caret"></span><span class="sr-only"></span>
                                                                </button>

                                                                <div class="dropdown-menu dropdown-menu-right">
                                                                    <a href="<?php echo e(url('accounting/settings/account_subtypes/' . $key->id . '/edit'), false); ?>"
                                                                        class="dropdown-item">
                                                                        <i class="fas fa-edit" aria-hidden="true"></i>
                                                                        <span><?php echo e(trans_choice('accounting::lang.edit', 1), false); ?></span>
                                                                    </a>
                                                                    <div class="dropdown-divider"></div>
                                                                    <a href="#" class="dropdown-item confirm-delete"
                                                                        form_id="delete-account-subtype-<?php echo e($key->id, false); ?>-form"
                                                                        action="<?php echo e(url('accounting/settings/account_subtypes/' . $key->id . '/destroy'), false); ?>">
                                                                        <i class="fas fa-trash" aria-hidden="true"></i>
                                                                        <span><?php echo e(trans_choice('accounting::lang.delete', 1), false); ?></span>
                                                                    </a>
                                                                    <form id="delete-account-subtype-<?php echo e($key->id, false); ?>-form" method="post">
                                                                        <?php echo csrf_field(); ?>
                                                                        <?php echo method_field('delete'); ?>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php $__env->endSlot(); ?>
                    <?php echo $__env->renderComponent(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </section>

        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('tab-modal-content'); ?>
    <?php echo $__env->make('accounting::settings.account_subtypes.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('tab-javascript'); ?>
    <script>
        const app = new Vue({
            el: '#vue-app-with-modal',
            data: {
                account_types: <?php echo json_encode($account_types); ?>,
                account_type: "<?php echo e(old('account_subtype_id'), false); ?>",
                name: "<?php echo e(old('name'), false); ?>",
                description: "<?php echo e(old('description'), false); ?>",
                active: <?php echo e(old('active', 1), false); ?>,
            },

            methods: {
                setAccountType(account_type) {
                    this.account_type = account_type;
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('accounting::settings.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\bungoma\Modules\Accounting\Providers/../Resources/views/settings/account_subtypes/index.blade.php ENDPATH**/ ?>