<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('accounting::general.journal', 1), false); ?> <?php echo e(trans_choice('accounting::lang.entry', 2), false); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('accounting::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Header (Page header) -->
    <?php $__env->startComponent('accounting::components.section_header'); ?>
        <?php $__env->slot('title'); ?>
            <?php echo e(trans_choice('accounting::general.accounting', 1), false); ?>

        <?php $__env->endSlot(); ?>
        <?php $__env->slot('subtitle'); ?>
            <?php echo e(trans_choice('accounting::general.journal', 1), false); ?> <?php echo e(trans_choice('accounting::lang.entry', 2), false); ?>

        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>

    <!-- Main content -->
    <section class="content no-print" id="vue-app">

        <div class="row">
            <div class="col-md-12">
                <?php $__env->startComponent('accounting::components.filters', ['title' => __('report.filters')]); ?>
                    <form method="get" action="<?php echo e(Request::url(), false); ?>">
                        <div class="modal-body">

                            <div class="form-group <?php if(!count($_GET) > 0): ?> d-none <?php endif; ?>">
                                <a class="btn btn-sm btn-success" href="<?php echo e(Request::url(), false); ?>">
                                    <i class="fa fa-filter"></i>
                                    <?php echo e(trans_choice('accounting::lang.clear', 1), false); ?> <?php echo e(trans_choice('accounting::lang.filter', 2), false); ?>

                                </a>
                            </div>

                            <div class="form-group">
                                <label for="chart_of_account_id" class="control-label"><?php echo e(trans_choice('accounting::general.account', 1), false); ?></label>
                                <!--<v-select v-model="chart_of_account_id" :options="chart_of_accounts" :reduce="chart_of_accounts => chart_of_accounts.id" label="name"/>-->
                                <select class="form-control select2" name="chart_of_account_id" v-model="chart_of_account_id"
                                    style="width: 100%; height: calc(2.25rem + 2px)">
                                    <option value="">All accounts</option>
                                    <option v-for="account in chart_of_accounts" :value="account.id">{{ account.name }}</option>
                                </select>
                            </div>
                            <!--<input type="hidden" name="chart_of_account_id" :value="chart_of_account_id">-->

                            <div class="row">
                                <div class="form-group col-md-6">
                                    <label for="start_date" class="control-label"><?php echo e(trans_choice('accounting::lang.start_date', 1), false); ?></label>
                                    <input class="form-control datepicker" v-model="start_date" type="text" name="start_date" id="start_date"
                                        readonly>
                                    <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message, false); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group col-md-6">
                                    <label for="end_date" class="control-label"><?php echo e(trans_choice('accounting::lang.end_date', 1), false); ?></label>
                                    <input class="form-control datepicker" v-model="end_date" type="text" name="end_date" id="end_date"
                                        readonly>
                                    <?php $__errorArgs = ['end_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message, false); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>


                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary"><?php echo e(trans_choice('accounting::lang.filter', 1), false); ?></button>
                        </div>
                    </form>
                <?php echo $__env->renderComponent(); ?>
            </div>
        </div>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.view')): ?>
            <div class="row">

                <?php $__env->startComponent('accounting::components.box'); ?>
                    <?php $__env->slot('header'); ?>
                        <div class="box-tools">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('accounting.journal_entries.create')): ?>
                                <a href="<?php echo e(url('accounting/journal_entry/create'), false); ?>" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> <?php echo e(trans_choice('accounting::lang.add', 1), false); ?>

                                </a>
                            <?php endif; ?>
                        </div>
                    <?php $__env->endSlot(); ?>

                    <?php $__env->slot('body'); ?>
                        <section class="content">
                            <div class="card">
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table id="data-table" class="table table-striped table-hover">
                                            <thead>
                                                <tr>
                                                    <th><?php echo e(trans_choice('accounting::lang.action', 1), false); ?></th>
                                                    <th>
                                                        <?php echo e(trans_choice('accounting::lang.entry', 1), false); ?> <?php echo e(trans_choice('accounting::lang.id', 1), false); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('accounting::lang.business_location', 1), false); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('accounting::lang.transaction', 1), false); ?>

                                                        <?php echo e(trans_choice('accounting::lang.date', 1), false); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('accounting::lang.transaction', 1), false); ?>#
                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('accounting::lang.type', 1), false); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('accounting::lang.account', 1), false); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('accounting::general.account_subtype', 1), false); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('accounting::lang.account', 1), false); ?>

                                                        <?php echo e(trans_choice('accounting::general.detail_type', 1), false); ?>

                                                    </th>
                                                    <th style="text-align: right">
                                                        <?php echo e(trans_choice('accounting::general.debit', 1), false); ?>

                                                    </th>
                                                    <th style="text-align: right">
                                                        <?php echo e(trans_choice('accounting::general.credit', 1), false); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('accounting::lang.created_by', 1), false); ?>

                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td>
                                                            <div class="btn-group">
                                                                <button href="#" class="btn btn-info dropdown-toggle btn-xs" data-toggle="dropdown"
                                                                    aria-expanded="false"><?php echo e(trans_choice('accounting::lang.action', 1), false); ?>

                                                                    <span class="caret"></span><span class="sr-only"></span>
                                                                </button>
                                                                <div class="dropdown-menu dropdown-menu-left">
                                                                    <a href="<?php echo e(url('accounting/journal_entry/' . $key->transaction_number . '/show'), false); ?>"
                                                                        class="dropdown-item">
                                                                        <i class="fas fa-eye"></i>
                                                                        <span><?php echo e(trans_choice('accounting::lang.detail', 2), false); ?></span>
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </td>

                                                        <td>
                                                            <a href="<?php echo e(url('accounting/journal_entry/' . $key->transaction_number . '/show'), false); ?>">
                                                                <span><?php echo e($key->id, false); ?></span> <i class="fas fa-external-link-alt"></i>
                                                            </a>
                                                        </td>
                                                        <td>
                                                            <a href="<?php echo e(url('business_location/' . $key->location_id . '/show'), false); ?>">
                                                                <span><?php echo e($key->business_location, false); ?></span> <i class="fas fa-external-link-alt"></i>
                                                            </a>
                                                        </td>
                                                        <td>
                                                            <span><?php echo e($key->date, false); ?></span>
                                                        </td>
                                                        <td>
                                                            <span><?php echo e($key->transaction_number, false); ?></span>
                                                        </td>
                                                        <td>
                                                            <?php if($key->account_type == 'asset'): ?>
                                                                <span><?php echo e(trans_choice('accounting::general.asset', 1), false); ?></span>
                                                            <?php elseif($key->account_type == 'expense'): ?>
                                                                <span><?php echo e(trans_choice('accounting::general.expense', 1), false); ?></span>
                                                            <?php elseif($key->account_type == 'equity'): ?>
                                                                <span><?php echo e(trans_choice('accounting::general.equity', 1), false); ?></span>
                                                            <?php elseif($key->account_type == 'liability'): ?>
                                                                <span><?php echo e(trans_choice('accounting::general.liability', 1), false); ?></span>
                                                            <?php elseif($key->account_type == 'income'): ?>
                                                                <span><?php echo e(trans_choice('accounting::general.income', 1), false); ?></span>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td>
                                                            <span><?php echo e($key->account_name, false); ?></span>
                                                        </td>
                                                        <td>
                                                            <span><?php echo e($key->account_subtype, false); ?></span>
                                                        </td>
                                                        <td>
                                                            <span><?php echo e($key->account_detail_type, false); ?></span>
                                                        </td>
                                                        <td style="text-align: right">
                                                            <span><?php echo e(number_format($key->debit), false); ?></span>
                                                        </td>
                                                        <td style="text-align: right">
                                                            <span><?php echo e(number_format($key->credit), false); ?></span>
                                                        </td>
                                                        <td>
                                                            <a href="<?php echo e(url('user/' . $key->created_by_id . '/show'), false); ?>">
                                                                <span><?php echo e($key->created_by, false); ?></span> <i class="fas fa-external-link-alt"></i>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                        </section>
                    <?php $__env->endSlot(); ?>
                <?php echo $__env->renderComponent(); ?>

            </div>
        <?php endif; ?>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
    <script>
        $(document).ready(function() {
            $('#data-table').DataTable();
        });
    </script>

    <script>
        var app = new Vue({
            el: "#vue-app",
            data: {
                records: <?php echo json_encode($data); ?>,
                selectAll: false,
                selectedRecords: [],
                chart_of_accounts: <?php echo json_encode($chart_of_accounts); ?>,
                chart_of_account_id: "<?php echo e(Request::get('chart_of_account_id'), false); ?>",
                start_date: "<?php echo e(Request::get('start_date'), false); ?>",
                end_date: "<?php echo e(Request::get('end_date'), false); ?>"
            },
            methods: {
                selectAllRecords() {
                    this.selectedRecords = [];
                    if (this.selectAll) {
                        this.records.data.forEach(item => {
                            this.selectedRecords.push(item.id);
                        });
                    }
                },
            },

            watch: {
                start_date(value) {

                    //If the end date has not been chosen set it to the value of the start_date
                    if (this.end_date == '') {
                        this.end_date = value;
                        return;
                    }

                    const start_date = new Date(value);
                    const end_date = new Date(this.end_date);

                    if (start_date > end_date) {
                        this.end_date = value;
                    }
                },
            }
        })

        $(".select2").select2();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('accounting::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\bungoma\Modules\Accounting\Providers/../Resources/views/journal_entry/index.blade.php ENDPATH**/ ?>