<?php $__env->startSection('title', 'Transfers'); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('accounting::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>Transfer
            <small>Manage your Transfers</small>
        </h1>
    </section>

    <!-- Main content -->
    <section class="content">

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('account.access')): ?>
            <div class="row">
                <div class="col-sm-12">
                    <div class="nav-tabs-custom">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#transfers" data-toggle="tab">
                                    <i class="fa fa-book"></i> <strong>Transfer</strong>
                                </a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="transfers">
                                <div class="row">
                                    <div class="col-md-12">
                                        <?php $__env->startComponent('accounting::components.widget'); ?>
                                            <div class="col-md-8 col-md-offset-4">
                                                <button data-href="<?php echo e(url('accounting/transfers/create'), false); ?>"
                                                    class="btn btn-primary btn-modal pull-right" data-container=".account_model">
                                                    <i class="fa fa-plus"></i> <?php echo app('translator')->get('messages.add'); ?></button>
                                            </div>
                                        <?php echo $__env->renderComponent(); ?>
                                    </div>
                                    <div class="col-sm-12">
                                        <br>
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped" id="transfers_table">
                                                <thead>
                                                    <tr>
                                                        <th>ID</th>
                                                        <th>Journal Entry</th>
                                                        <th>Transfer from</th>
                                                        <th></th>
                                                        <th>Transfer To</th>
                                                        <th>Transfer By</th>
                                                        <th>Amount</th>
                                                        <th>Date</th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="modal fade account_model" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
        </div>

        <div class="modal fade" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel" id="account_type_modal">
        </div>
    </section>
    <!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script>
        $(document).ready(function() {

            const transfers_table = $('#transfers_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: '/accounting/transfers',
                columns: [{
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'journal_entry',
                        name: 'journal_entry'
                    },
                    {
                        data: 'transfer_from',
                        name: 'transfer_from'
                    },
                    {
                        data: 'arrow_right',
                        name: 'arrow_right',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'transfer_to',
                        name: 'transfer_to'
                    },
                    {
                        data: 'transfer_by',
                        name: 'transfer_by'
                    },
                    {
                        data: 'amount',
                        name: 'amount'
                    },
                    {
                        data: 'created_at',
                        name: 'created_at'
                    },
                ],
            });

            $(document).on('submit', 'form#fund_transfer_form', function(e) {
                e.preventDefault();
                var data = $(this).serialize();
                $.ajax({
                    method: "post",
                    url: $(this).attr("action"),
                    dataType: "json",
                    data: data,
                    success: function(result) {
                        if (result.success == true) {
                            $('div.account_model').modal('hide');
                            toastr.success(result.msg);
                            transfers_table.ajax.reload();
                        } else {
                            toastr.error(result.msg);
                        }
                    }
                });
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('accounting::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\bungoma\Modules\Accounting\Providers/../Resources/views/transfers/index.blade.php ENDPATH**/ ?>