<?php

use Modules\Accounting\Entities\Country;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCountriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('countries', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('sortname');
            $table->string('name');
            $table->timestamps();
        });

        $countries = array(
            array('sortname' => 'AF', 'name' => 'Afghanistan'),
            array('sortname' => 'AL', 'name' => 'Albania'),
            array('sortname' => 'DZ', 'name' => 'Algeria'),
            array('sortname' => 'AS', 'name' => 'American Samoa'),
            array('sortname' => 'AD', 'name' => 'Andorra'),
            array('sortname' => 'AO', 'name' => 'Angola'),
            array('sortname' => 'AI', 'name' => 'Anguilla'),
            array('sortname' => 'AQ', 'name' => 'Antarctica'),
            array('sortname' => 'AG', 'name' => 'Antigua And Barbuda'),
            array('sortname' => 'AR', 'name' => 'Argentina'),
            array('sortname' => 'AM', 'name' => 'Armenia'),
            array('sortname' => 'AW', 'name' => 'Aruba'),
            array('sortname' => 'AU', 'name' => 'Australia'),
            array('sortname' => 'AT', 'name' => 'Austria'),
            array('sortname' => 'AZ', 'name' => 'Azerbaijan'),
            array('sortname' => 'BS', 'name' => 'Bahamas The'),
            array('sortname' => 'BH', 'name' => 'Bahrain'),
            array('sortname' => 'BD', 'name' => 'Bangladesh'),
            array('sortname' => 'BB', 'name' => 'Barbados'),
            array('sortname' => 'BY', 'name' => 'Belarus'),
            array('sortname' => 'BE', 'name' => 'Belgium'),
            array('sortname' => 'BZ', 'name' => 'Belize'),
            array('sortname' => 'BJ', 'name' => 'Benin'),
            array('sortname' => 'BM', 'name' => 'Bermuda'),
            array('sortname' => 'BT', 'name' => 'Bhutan'),
            array('sortname' => 'BO', 'name' => 'Bolivia'),
            array('sortname' => 'BA', 'name' => 'Bosnia and Herzegovina'),
            array('sortname' => 'BW', 'name' => 'Botswana'),
            array('sortname' => 'BV', 'name' => 'Bouvet Island'),
            array('sortname' => 'BR', 'name' => 'Brazil'),
            array('sortname' => 'IO', 'name' => 'British Indian Ocean Territory'),
            array('sortname' => 'BN', 'name' => 'Brunei'),
            array('sortname' => 'BG', 'name' => 'Bulgaria'),
            array('sortname' => 'BF', 'name' => 'Burkina Faso'),
            array('sortname' => 'BI', 'name' => 'Burundi'),
            array('sortname' => 'KH', 'name' => 'Cambodia'),
            array('sortname' => 'CM', 'name' => 'Cameroon'),
            array('sortname' => 'CA', 'name' => 'Canada'),
            array('sortname' => 'CV', 'name' => 'Cape Verde'),
            array('sortname' => 'KY', 'name' => 'Cayman Islands'),
            array('sortname' => 'CF', 'name' => 'Central African Republic'),
            array('sortname' => 'TD', 'name' => 'Chad'),
            array('sortname' => 'CL', 'name' => 'Chile'),
            array('sortname' => 'CN', 'name' => 'China'),
            array('sortname' => 'CX', 'name' => 'Christmas Island'),
            array('sortname' => 'CC', 'name' => 'Cocos (Keeling) Islands'),
            array('sortname' => 'CO', 'name' => 'Colombia'),
            array('sortname' => 'KM', 'name' => 'Comoros'),
            array('sortname' => 'CG', 'name' => 'Congo'),
            array('sortname' => 'CD', 'name' => 'Congo The Democratic Republic Of The'),
            array('sortname' => 'CK', 'name' => 'Cook Islands'),
            array('sortname' => 'CR', 'name' => 'Costa Rica'),
            array('sortname' => 'CI', 'name' => 'Cote D\'Ivoire (Ivory Coast)'),
            array('sortname' => 'HR', 'name' => 'Croatia (Hrvatska)'),
            array('sortname' => 'CU', 'name' => 'Cuba'),
            array('sortname' => 'CY', 'name' => 'Cyprus'),
            array('sortname' => 'CZ', 'name' => 'Czech Republic'),
            array('sortname' => 'DK', 'name' => 'Denmark'),
            array('sortname' => 'DJ', 'name' => 'Djibouti'),
            array('sortname' => 'DM', 'name' => 'Dominica'),
            array('sortname' => 'DO', 'name' => 'Dominican Republic'),
            array('sortname' => 'TP', 'name' => 'East Timor'),
            array('sortname' => 'EC', 'name' => 'Ecuador'),
            array('sortname' => 'EG', 'name' => 'Egypt'),
            array('sortname' => 'SV', 'name' => 'El Salvador'),
            array('sortname' => 'GQ', 'name' => 'Equatorial Guinea'),
            array('sortname' => 'ER', 'name' => 'Eritrea'),
            array('sortname' => 'EE', 'name' => 'Estonia'),
            array('sortname' => 'ET', 'name' => 'Ethiopia'),
            array('sortname' => 'XA', 'name' => 'External Territories of Australia'),
            array('sortname' => 'FK', 'name' => 'Falkland Islands'),
            array('sortname' => 'FO', 'name' => 'Faroe Islands'),
            array('sortname' => 'FJ', 'name' => 'Fiji Islands'),
            array('sortname' => 'FI', 'name' => 'Finland'),
            array('sortname' => 'FR', 'name' => 'France'),
            array('sortname' => 'GF', 'name' => 'French Guiana'),
            array('sortname' => 'PF', 'name' => 'French Polynesia'),
            array('sortname' => 'TF', 'name' => 'French Southern Territories'),
            array('sortname' => 'GA', 'name' => 'Gabon'),
            array('sortname' => 'GM', 'name' => 'Gambia The'),
            array('sortname' => 'GE', 'name' => 'Georgia'),
            array('sortname' => 'DE', 'name' => 'Germany'),
            array('sortname' => 'GH', 'name' => 'Ghana'),
            array('sortname' => 'GI', 'name' => 'Gibraltar'),
            array('sortname' => 'GR', 'name' => 'Greece'),
            array('sortname' => 'GL', 'name' => 'Greenland'),
            array('sortname' => 'GD', 'name' => 'Grenada'),
            array('sortname' => 'GP', 'name' => 'Guadeloupe'),
            array('sortname' => 'GU', 'name' => 'Guam'),
            array('sortname' => 'GT', 'name' => 'Guatemala'),
            array('sortname' => 'XU', 'name' => 'Guernsey and Alderney'),
            array('sortname' => 'GN', 'name' => 'Guinea'),
            array('sortname' => 'GW', 'name' => 'Guinea-Bissau'),
            array('sortname' => 'GY', 'name' => 'Guyana'),
            array('sortname' => 'HT', 'name' => 'Haiti'),
            array('sortname' => 'HM', 'name' => 'Heard and McDonald Islands'),
            array('sortname' => 'HN', 'name' => 'Honduras'),
            array('sortname' => 'HK', 'name' => 'Hong Kong S.A.R.'),
            array('sortname' => 'HU', 'name' => 'Hungary'),
            array('sortname' => 'IS', 'name' => 'Iceland'),
            array('sortname' => 'IN', 'name' => 'India'),
            array('sortname' => 'ID', 'name' => 'Indonesia'),
            array('sortname' => 'IR', 'name' => 'Iran'),
            array('sortname' => 'IQ', 'name' => 'Iraq'),
            array('sortname' => 'IE', 'name' => 'Ireland'),
            array('sortname' => 'IL', 'name' => 'Israel'),
            array('sortname' => 'IT', 'name' => 'Italy'),
            array('sortname' => 'JM', 'name' => 'Jamaica'),
            array('sortname' => 'JP', 'name' => 'Japan'),
            array('sortname' => 'XJ', 'name' => 'Jersey'),
            array('sortname' => 'JO', 'name' => 'Jordan'),
            array('sortname' => 'KZ', 'name' => 'Kazakhstan'),
            array('sortname' => 'KE', 'name' => 'Kenya'),
            array('sortname' => 'KI', 'name' => 'Kiribati'),
            array('sortname' => 'KP', 'name' => 'Korea North'),
            array('sortname' => 'KR', 'name' => 'Korea South'),
            array('sortname' => 'KW', 'name' => 'Kuwait'),
            array('sortname' => 'KG', 'name' => 'Kyrgyzstan'),
            array('sortname' => 'LA', 'name' => 'Laos'),
            array('sortname' => 'LV', 'name' => 'Latvia'),
            array('sortname' => 'LB', 'name' => 'Lebanon'),
            array('sortname' => 'LS', 'name' => 'Lesotho'),
            array('sortname' => 'LR', 'name' => 'Liberia'),
            array('sortname' => 'LY', 'name' => 'Libya'),
            array('sortname' => 'LI', 'name' => 'Liechtenstein'),
            array('sortname' => 'LT', 'name' => 'Lithuania'),
            array('sortname' => 'LU', 'name' => 'Luxembourg'),
            array('sortname' => 'MO', 'name' => 'Macau S.A.R.'),
            array('sortname' => 'MK', 'name' => 'Macedonia'),
            array('sortname' => 'MG', 'name' => 'Madagascar'),
            array('sortname' => 'MW', 'name' => 'Malawi'),
            array('sortname' => 'MY', 'name' => 'Malaysia'),
            array('sortname' => 'MV', 'name' => 'Maldives'),
            array('sortname' => 'ML', 'name' => 'Mali'),
            array('sortname' => 'MT', 'name' => 'Malta'),
            array('sortname' => 'XM', 'name' => 'Man (Isle of)'),
            array('sortname' => 'MH', 'name' => 'Marshall Islands'),
            array('sortname' => 'MQ', 'name' => 'Martinique'),
            array('sortname' => 'MR', 'name' => 'Mauritania'),
            array('sortname' => 'MU', 'name' => 'Mauritius'),
            array('sortname' => 'YT', 'name' => 'Mayotte'),
            array('sortname' => 'MX', 'name' => 'Mexico'),
            array('sortname' => 'FM', 'name' => 'Micronesia'),
            array('sortname' => 'MD', 'name' => 'Moldova'),
            array('sortname' => 'MC', 'name' => 'Monaco'),
            array('sortname' => 'MN', 'name' => 'Mongolia'),
            array('sortname' => 'MS', 'name' => 'Montserrat'),
            array('sortname' => 'MA', 'name' => 'Morocco'),
            array('sortname' => 'MZ', 'name' => 'Mozambique'),
            array('sortname' => 'MM', 'name' => 'Myanmar'),
            array('sortname' => 'NA', 'name' => 'Namibia'),
            array('sortname' => 'NR', 'name' => 'Nauru'),
            array('sortname' => 'NP', 'name' => 'Nepal'),
            array('sortname' => 'AN', 'name' => 'Netherlands Antilles'),
            array('sortname' => 'NL', 'name' => 'Netherlands The'),
            array('sortname' => 'NC', 'name' => 'New Caledonia'),
            array('sortname' => 'NZ', 'name' => 'New Zealand'),
            array('sortname' => 'NI', 'name' => 'Nicaragua'),
            array('sortname' => 'NE', 'name' => 'Niger'),
            array('sortname' => 'NG', 'name' => 'Nigeria'),
            array('sortname' => 'NU', 'name' => 'Niue'),
            array('sortname' => 'NF', 'name' => 'Norfolk Island'),
            array('sortname' => 'MP', 'name' => 'Northern Mariana Islands'),
            array('sortname' => 'NO', 'name' => 'Norway'),
            array('sortname' => 'OM', 'name' => 'Oman'),
            array('sortname' => 'PK', 'name' => 'Pakistan'),
            array('sortname' => 'PW', 'name' => 'Palau'),
            array('sortname' => 'PS', 'name' => 'Palestinian Territory Occupied'),
            array('sortname' => 'PA', 'name' => 'Panama'),
            array('sortname' => 'PG', 'name' => 'Papua new Guinea'),
            array('sortname' => 'PY', 'name' => 'Paraguay'),
            array('sortname' => 'PE', 'name' => 'Peru'),
            array('sortname' => 'PH', 'name' => 'Philippines'),
            array('sortname' => 'PN', 'name' => 'Pitcairn Island'),
            array('sortname' => 'PL', 'name' => 'Poland'),
            array('sortname' => 'PT', 'name' => 'Portugal'),
            array('sortname' => 'PR', 'name' => 'Puerto Rico'),
            array('sortname' => 'QA', 'name' => 'Qatar'),
            array('sortname' => 'RE', 'name' => 'Reunion'),
            array('sortname' => 'RO', 'name' => 'Romania'),
            array('sortname' => 'RU', 'name' => 'Russia'),
            array('sortname' => 'RW', 'name' => 'Rwanda'),
            array('sortname' => 'SH', 'name' => 'Saint Helena'),
            array('sortname' => 'KN', 'name' => 'Saint Kitts And Nevis'),
            array('sortname' => 'LC', 'name' => 'Saint Lucia'),
            array('sortname' => 'PM', 'name' => 'Saint Pierre and Miquelon'),
            array('sortname' => 'VC', 'name' => 'Saint Vincent And The Grenadines'),
            array('sortname' => 'WS', 'name' => 'Samoa'),
            array('sortname' => 'SM', 'name' => 'San Marino'),
            array('sortname' => 'ST', 'name' => 'Sao Tome and Principe'),
            array('sortname' => 'SA', 'name' => 'Saudi Arabia'),
            array('sortname' => 'SN', 'name' => 'Senegal'),
            array('sortname' => 'RS', 'name' => 'Serbia'),
            array('sortname' => 'SC', 'name' => 'Seychelles'),
            array('sortname' => 'SL', 'name' => 'Sierra Leone'),
            array('sortname' => 'SG', 'name' => 'Singapore'),
            array('sortname' => 'SK', 'name' => 'Slovakia'),
            array('sortname' => 'SI', 'name' => 'Slovenia'),
            array('sortname' => 'XG', 'name' => 'Smaller Territories of the UK'),
            array('sortname' => 'SB', 'name' => 'Solomon Islands'),
            array('sortname' => 'SO', 'name' => 'Somalia'),
            array('sortname' => 'ZA', 'name' => 'South Africa'),
            array('sortname' => 'GS', 'name' => 'South Georgia'),
            array('sortname' => 'SS', 'name' => 'South Sudan'),
            array('sortname' => 'ES', 'name' => 'Spain'),
            array('sortname' => 'LK', 'name' => 'Sri Lanka'),
            array('sortname' => 'SD', 'name' => 'Sudan'),
            array('sortname' => 'SR', 'name' => 'Suriname'),
            array('sortname' => 'SJ', 'name' => 'Svalbard And Jan Mayen Islands'),
            array('sortname' => 'SZ', 'name' => 'Swaziland'),
            array('sortname' => 'SE', 'name' => 'Sweden'),
            array('sortname' => 'CH', 'name' => 'Switzerland'),
            array('sortname' => 'SY', 'name' => 'Syria'),
            array('sortname' => 'TW', 'name' => 'Taiwan'),
            array('sortname' => 'TJ', 'name' => 'Tajikistan'),
            array('sortname' => 'TZ', 'name' => 'Tanzania'),
            array('sortname' => 'TH', 'name' => 'Thailand'),
            array('sortname' => 'TG', 'name' => 'Togo'),
            array('sortname' => 'TK', 'name' => 'Tokelau'),
            array('sortname' => 'TO', 'name' => 'Tonga'),
            array('sortname' => 'TT', 'name' => 'Trinidad And Tobago'),
            array('sortname' => 'TN', 'name' => 'Tunisia'),
            array('sortname' => 'TR', 'name' => 'Turkey'),
            array('sortname' => 'TM', 'name' => 'Turkmenistan'),
            array('sortname' => 'TC', 'name' => 'Turks And Caicos Islands'),
            array('sortname' => 'TV', 'name' => 'Tuvalu'),
            array('sortname' => 'UG', 'name' => 'Uganda'),
            array('sortname' => 'UA', 'name' => 'Ukraine'),
            array('sortname' => 'AE', 'name' => 'United Arab Emirates'),
            array('sortname' => 'GB', 'name' => 'United Kingdom'),
            array('sortname' => 'US', 'name' => 'United States'),
            array('sortname' => 'UM', 'name' => 'United States Minor Outlying Islands'),
            array('sortname' => 'UY', 'name' => 'Uruguay'),
            array('sortname' => 'UZ', 'name' => 'Uzbekistan'),
            array('sortname' => 'VU', 'name' => 'Vanuatu'),
            array('sortname' => 'VA', 'name' => 'Vatican City State (Holy See)'),
            array('sortname' => 'VE', 'name' => 'Venezuela'),
            array('sortname' => 'VN', 'name' => 'Vietnam'),
            array('sortname' => 'VG', 'name' => 'Virgin Islands (British)'),
            array('sortname' => 'VI', 'name' => 'Virgin Islands (US)'),
            array('sortname' => 'WF', 'name' => 'Wallis And Futuna Islands'),
            array('sortname' => 'EH', 'name' => 'Western Sahara'),
            array('sortname' => 'YE', 'name' => 'Yemen'),
            array('sortname' => 'YU', 'name' => 'Yugoslavia'),
            array('sortname' => 'ZM', 'name' => 'Zambia'),
            array('sortname' => 'ZW', 'name' => 'Zimbabwe')
        );

        Country::insert($countries);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('countries');
    }
}
